

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************


**********************************************************************************
**********************************************************************************
*** Figure A.3: Distribution of spatially correlated noise effects on Religious Laws in 1000 simulations
**********************************************************************************

***
*** Figure top-left
* Graph the Distribution of spatially correlated noise effects on religious laws in 1000 simulations, with a cutoff of 300kms
***
use country_final, clear

reghdfe rslegis god, a(continent) vce(r)

gen regsample=.
replace regsample=1 if e(sample)
keep if regsample==1

forvalues j = 1(1)1000 {
gen noise`j'=rnormal()
gen distance_ij`j'=.
gen spatialnoise`j'=.

forvalues i = 1(1)119{
local lat`i' = lat[`i']
local lon`i' = lon[`i']
geodist lat lon `lat`i'' `lon`i'' , generate(dist) sphere
replace distance_ij`j' = dist
drop dist
egen tempnoise`j'=total(((1-(distance_ij`j'/300))*noise`j')) if distance_ij`j'<=2000
replace spatialnoise`j' = tempnoise`j' if _n==`i'
drop tempnoise`j'
}
drop distance_ij`j'

gen total_noise`j'=noise`j'+spatialnoise`j'

* baseline specification
reghdfe rslegis total_noise`j', a(continent) 
matrix b=e(b)
scalar b=b[1,1]
gen betacol3`j'=b
 
}


preserve
keep beta*
gen trend=_n
keep if trend==1
reshape long betacol3, i(trend) j(id) string
drop trend
gen trend=_n
drop if trend>1000
twoway (kdensity betacol3 ) , title(Effect of spatial noise within 300km on Religious Laws) ytitle(kdensity) xtitle(Spatial noise effect)  legend(lab(1 "Effect of spatial noise within 300km")) xsize(5.5) ysize(4) scheme(Plotplainblind)  play (solomon2)

restore


***
*** Figure top-right
* Graph the Distribution of spatially correlated noise effects on religious laws in 1000 simulations, with a cutoff of 500kms
***
use country_final, clear

reghdfe rslegis god, a(continent) vce(r)

gen regsample=.
replace regsample=1 if e(sample)
keep if regsample==1

forvalues j = 1(1)1000 {
gen noise`j'=rnormal()
gen distance_ij`j'=.
gen spatialnoise`j'=.

forvalues i = 1(1)119{
local lat`i' = lat[`i']
local lon`i' = lon[`i']
geodist lat lon `lat`i'' `lon`i'' , generate(dist) sphere
replace distance_ij`j' = dist
drop dist
egen tempnoise`j'=total(((1-(distance_ij`j'/500))*noise`j')) if distance_ij`j'<=2000
replace spatialnoise`j' = tempnoise`j' if _n==`i'
drop tempnoise`j'
}
drop distance_ij`j'

gen total_noise`j'=noise`j'+spatialnoise`j'

* baseline specification
reghdfe rslegis total_noise`j', a(continent) 
matrix b=e(b)
scalar b=b[1,1]
gen betacol3`j'=b
 
}


preserve
keep beta*
gen trend=_n
keep if trend==1
reshape long betacol3, i(trend) j(id) string
drop trend
gen trend=_n
drop if trend>1000
twoway (kdensity betacol3 ) , title(Effect of spatial noise within 500km on Religious Laws) ytitle(kdensity) xtitle(Spatial noise effect)  legend(lab(1 "Effect of spatial noise within 500km")) xsize(5.5) ysize(4) scheme(Plotplainblind)  play (solomon2)

restore


***
*** Figure bottom-left
* Graph the Distribution of spatially correlated noise effects on religious laws in 1000 simulations, with a cutoff of 1000kms
***
use country_final, clear

reghdfe rslegis god, a(continent) vce(r)

gen regsample=.
replace regsample=1 if e(sample)
keep if regsample==1

forvalues j = 1(1)1000 {
gen noise`j'=rnormal()
gen distance_ij`j'=.
gen spatialnoise`j'=.

forvalues i = 1(1)119{
local lat`i' = lat[`i']
local lon`i' = lon[`i']
geodist lat lon `lat`i'' `lon`i'' , generate(dist) sphere
replace distance_ij`j' = dist
drop dist
egen tempnoise`j'=total(((1-(distance_ij`j'/1000))*noise`j')) if distance_ij`j'<=2000
replace spatialnoise`j' = tempnoise`j' if _n==`i'
drop tempnoise`j'
}
drop distance_ij`j'

gen total_noise`j'=noise`j'+spatialnoise`j'

* baseline specification
reghdfe rslegis total_noise`j', a(continent) 
matrix b=e(b)
scalar b=b[1,1]
gen betacol3`j'=b
 
}


preserve
keep beta*
gen trend=_n
keep if trend==1
reshape long betacol3, i(trend) j(id) string
drop trend
gen trend=_n
drop if trend>1000
twoway (kdensity betacol3 ) , title(Effect of spatial noise within 1000km on Religious Laws) ytitle(kdensity) xtitle(Spatial noise effect)  legend(lab(1 "Effect of spatial noise within 1000km")) xsize(5.5) ysize(4) scheme(Plotplainblind)  play (solomon2)

restore


***
*** Figure bottom-right
* Graph the Distribution of spatially correlated noise effects on religious laws in 1000 simulations, with a cutoff of 2000kms
***
use country_final, clear

reghdfe rslegis god, a(continent) vce(r)

gen regsample=.
replace regsample=1 if e(sample)
keep if regsample==1

forvalues j = 1(1)1000 {
gen noise`j'=rnormal()
gen distance_ij`j'=.
gen spatialnoise`j'=.

forvalues i = 1(1)119{
local lat`i' = lat[`i']
local lon`i' = lon[`i']
geodist lat lon `lat`i'' `lon`i'' , generate(dist) sphere
replace distance_ij`j' = dist
drop dist
egen tempnoise`j'=total(((1-(distance_ij`j'/2000))*noise`j')) if distance_ij`j'<=2000
replace spatialnoise`j' = tempnoise`j' if _n==`i'
drop tempnoise`j'
}
drop distance_ij`j'

gen total_noise`j'=noise`j'+spatialnoise`j'

* baseline specification
reghdfe rslegis total_noise`j', a(continent) 
matrix b=e(b)
scalar b=b[1,1]
gen betacol3`j'=b
 
}


preserve
keep beta*
gen trend=_n
keep if trend==1
reshape long betacol3, i(trend) j(id) string
drop trend
gen trend=_n
drop if trend>1000
twoway (kdensity betacol3 ) , title(Effect of spatial noise within 2000km on Religious Laws) ytitle(kdensity) xtitle(Spatial noise effect)  legend(lab(1 "Effect of spatial noise within 2000km")) xsize(5.5) ysize(4) scheme(Plotplainblind)  play (solomon2)

restore


********************************************************************************************************************************************************************